IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'dbo.CF_Contratos_Cupos_Contar') 
                   and type = 'FN')
BEGIN
    DROP FUNCTION dbo.CF_Contratos_Cupos_Contar
END
GO

CREATE FUNCTION [dbo].[CF_Contratos_Cupos_Contar] 
(		@pId_Familia				INT
		,@pId_Prod_Familia_Sala		INT
		,@pId_Prod_Familia_Horario	INT
		,@pId_Producto				CHAR(14)
		,@pFecha					DATETIME
		,@pId_Contrato				INT = NULL /*21/02/2020. Si @pId_Contrato <> 0 se tiene que exluir de la suma (porque es un updaet)*/
)		
RETURNS INT
AS
BEGIN
	DECLARE @Flag_Valida_Cupo	TINYINT
	DECLARE @Cant				INT
	DECLARE @Flag_Periodo_Tipo  CHAR(1)
	DECLARE @Flag_Periodo_Desde DATETIME

	SELECT @Flag_Valida_Cupo = Flag_Valida_Cupo FROM Prod_Familias WHERE Id_Familia = @pId_Familia

	SET @Flag_Periodo_Tipo= (SELECT Flag_Periodo_Tipo from productos where id_producto=@pId_Producto)


	IF(@pId_Contrato IS NULL)
	BEGIN
		SET @pId_Contrato = 0
	END

	IF @Flag_Valida_Cupo = 0
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C
								JOIN Contratos_Prod P ON C.Id_Contrato = P.Id_Contrato
                               WHERE C.Activo = 1 
							   AND C.Fecha_Desde <= @pFecha
							   AND (C.Fecha_Hasta >= @pFecha + 1 OR C.Fecha_Hasta IS NULL)
							   AND P.Id_Producto = @pId_Producto
	   RETURN ISNULL(@Cant,0)
	END


	IF @Flag_Valida_Cupo = 1  --Por Sala
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C
								JOIN Contratos_Prod P ON C.Id_Contrato = P.Id_Contrato
                               WHERE C.Activo = 1
							   AND C.Fecha_Desde <= @pFecha
							   AND (
									C.Fecha_Hasta IS NULL
							        OR C.Fecha_Hasta >= @pFecha 
							        OR C.Fecha_Hasta >= GETDATE()
									)
							   AND C.Id_Contrato <> @pId_Contrato
							   AND P.Id_Prod_Familia_Sala = @pId_Prod_Familia_Sala
	   RETURN ISNULL(@Cant,0)
	END

	IF @Flag_Valida_Cupo = 2  --Por Sala Y Horario
	BEGIN
       SELECT @Cant = COUNT(*)  FROM Contratos C
								INNER JOIN Contratos_Prod P ON C.Id_Contrato = P.Id_Contrato 
								INNER JOIN Contratos_Prod_Horarios H ON H.Id_Contrato = C.Id_Contrato
                                WHERE
                                C.Activo = 1 
							    AND C.Fecha_Desde <= @pFecha
							    AND ( C.Fecha_Hasta IS NULL
									OR DATEADD(MONTH,1,C.Fecha_Hasta) >= @pFecha
									)
							    AND P.Id_Prod_Familia_Sala = @pId_Prod_Familia_Sala
							    AND C.Id_Contrato <> @pId_Contrato
							    AND H.Id_Prod_Familia_Horario = @pId_Prod_Familia_Horario
	   RETURN ISNULL(@Cant,0)
	END

	IF @Flag_Valida_Cupo = 3  --Por Sala Y Producto
	BEGIN

		IF @Flag_Periodo_Tipo= 'F'	
		BEGIN
		SET @Flag_Periodo_Desde = (SELECT Flag_Periodo_Desde FROM Productos WHERE Id_Producto=@pId_Producto) /*Toma la fecha desde del periodo fijo del  producto*/
		
		SELECT @Cant = COUNT(*) FROM Contratos C
								JOIN Contratos_Prod P ON C.Id_Contrato = P.Id_Contrato
                               WHERE C.Activo = 1
							   AND C.Fecha_Desde <= @Flag_Periodo_Desde
							   AND (
									C.Fecha_Hasta IS NULL
							        OR C.Fecha_Hasta >= @Flag_Periodo_Desde  
							        OR C.Fecha_Hasta >= GETDATE()
									)
							   AND P.Id_Prod_Familia_Sala = @pId_Prod_Familia_Sala
							   AND P.Id_Producto = @pId_Producto
							   AND C.Id_Contrato <> @pId_Contrato 
							   AND C.Activo=1

	   RETURN ISNULL(@Cant,0)

		IF @Flag_Periodo_Tipo<> 'F'	
	----SET @pFecha=(SELECT fecha_Desde FROM CONTRATOS WHERE id_contrato=@pId_Contrato)
     SELECT @Cant = COUNT(*) FROM Contratos C
								JOIN Contratos_Prod P ON C.Id_Contrato = P.Id_Contrato
                               WHERE C.Activo = 1
							   AND C.Fecha_Desde <= @pFecha
							   AND (
									C.Fecha_Hasta IS NULL
							        OR C.Fecha_Hasta >= @pFecha 
							        OR C.Fecha_Hasta >= GETDATE()
									)							  
							   AND P.Id_Prod_Familia_Sala = @pId_Prod_Familia_Sala
							   AND P.Id_Producto = @pId_Producto
							   AND C.Id_Contrato <> @pId_Contrato 

	   RETURN ISNULL(@Cant,0)
	END
		END

	IF @Flag_Valida_Cupo = 4  --Por Sala , Producto y Horario
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C
								JOIN Contratos_Prod P ON C.Id_Contrato = P.Id_Contrato
								JOIN Contratos_Prod_Horarios H ON H.Id_Contrato = C.Id_Contrato
                               WHERE C.Activo = 1
							   AND C.Fecha_Desde <= @pFecha
							   AND (
									C.Fecha_Hasta IS NULL
							        OR C.Fecha_Hasta >= @pFecha 
									)	
							   AND P.Id_Prod_Familia_Sala = @pId_Prod_Familia_Sala
							   AND H.Id_Prod_Familia_Horario = @pId_Prod_Familia_Horario
							   AND P.Id_Producto = @pId_Producto
							   AND C.Id_Contrato <> @pId_Contrato
	   RETURN ISNULL(@Cant,0)
	END

	IF @Flag_Valida_Cupo = 5  --Por Producto y Horario
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C
								JOIN Contratos_Prod P ON C.Id_Contrato = P.Id_Contrato
								JOIN Contratos_Prod_Horarios H ON H.Id_Contrato = C.Id_Contrato
                               WHERE C.Activo = 1
							   AND C.Fecha_Desde <= @pFecha
							   AND (
									C.Fecha_Hasta IS NULL
							        OR C.Fecha_Hasta >= @pFecha 
							        OR C.Fecha_Hasta >= GETDATE()
									)	
							   AND H.Id_Prod_Familia_Horario = @pId_Prod_Familia_Horario
							   AND P.Id_Producto = @pId_Producto
							   AND C.Id_Contrato <> @pId_Contrato
	   RETURN ISNULL(@Cant,0)
	END

	IF @Flag_Valida_Cupo = 6  --Por Horario Se modifica porque no esta tomando en cuenta las inscripciones que se realizan por un mes
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C
								JOIN Contratos_Prod P ON C.Id_Contrato = P.Id_Contrato
								JOIN Contratos_Prod_Horarios H ON H.Id_Contrato = C.Id_Contrato
                               WHERE C.Activo = 1
							   AND C.Fecha_Desde <= @pFecha
							   AND (
									C.Fecha_Hasta IS NULL
							        OR C.Fecha_Hasta >= @pFecha 
							        OR C.Fecha_Hasta >= GETDATE()
									)	
							   AND H.Id_Prod_Familia_Horario = @pId_Prod_Familia_Horario
							   --AND P.Id_Producto = @pId_Producto	----			//02/03/2021
							   AND C.Id_Contrato <> @pId_Contrato
	   RETURN ISNULL(@Cant,0)
	END
	
	IF @Flag_Valida_Cupo = 7  --Por Familia
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C
								JOIN Contratos_Prod P ON C.Id_Contrato = P.Id_Contrato
								JOIN Productos PR ON  P.Id_Producto = PR.Id_Producto
                               WHERE C.Activo = 1
							   AND C.Fecha_Desde <= @pFecha
							   AND (
									C.Fecha_Hasta IS NULL
							        OR C.Fecha_Hasta >= @pFecha 
									)	
							   AND PR.Id_Familia = @pId_Familia
							   AND C.Id_Contrato <> @pId_Contrato
		/* 02/03/2021
       SELECT @Cant = COUNT(*) FROM Contratos C, Contratos_Prod_Horarios H
                               WHERE C.Activo = 1 
							   AND C.Fecha_Desde <= @pFecha
							   AND ISNULL(C.Fecha_Hasta,@pFecha + 1) > @pFecha
							   AND H.Id_Contrato = C.Id_Contrato
							   AND H.Id_Prod_Familia_Horario = @pId_Prod_Familia_Horario
							   AND C.Id_Contrato <> @pId_Contrato
	   */
	   RETURN ISNULL(@Cant,0)
	END

	IF @Flag_Valida_Cupo = 8  --Por Producto 20220816
	BEGIN
       SELECT @Cant = COUNT(*) FROM Contratos C
								JOIN Contratos_Prod P ON C.Id_Contrato = P.Id_Contrato
                               WHERE C.Activo = 1
							   AND C.Fecha_Desde <= @pFecha
							   AND (
									C.Fecha_Hasta IS NULL
							        OR C.Fecha_Hasta >= @pFecha 
									)	
							   AND P.Id_Producto = @pId_Producto		
							   AND C.Id_Contrato <> @pId_Contrato
		
	   RETURN ISNULL(@Cant,0)
	END

	RETURN ISNULL(@Cant,0)
END	
		
